/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.essentials.tileentities.redstone;

import com.Da_Technomancer.essentials.blocks.ESBlocks;
import com.Da_Technomancer.essentials.blocks.redstone.AbstractCircuit;
import com.Da_Technomancer.essentials.blocks.redstone.RedstoneUtil;
import com.Da_Technomancer.essentials.gui.container.CircuitContainer;
import com.Da_Technomancer.essentials.gui.container.DelayCircuitContainer;
import com.Da_Technomancer.essentials.packets.INBTReceiver;
import com.Da_Technomancer.essentials.tileentities.ITickableTileEntity;
import com.Da_Technomancer.essentials.tileentities.redstone.CircuitTileEntity;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.ticks.TickPriority;
import net.minecraftforge.registries.ObjectHolder;
import org.apache.commons.lang3.tuple.Pair;

@ObjectHolder(value="essentials")
public class DelayCircuitTileEntity
extends CircuitTileEntity
implements MenuProvider,
INBTReceiver,
ITickableTileEntity {
    @ObjectHolder(value="delay_circuit")
    public static BlockEntityType<DelayCircuitTileEntity> TYPE = null;
    private static final int MIN_DELAY = 1;
    public int settingDelay = 2;
    public String settingStrDelay = "2";
    private long ticksExisted = 0L;
    private float currentOutput = 0.0f;
    private final ArrayList<Pair<Float, Long>> queuedOutputs = new ArrayList();

    public DelayCircuitTileEntity(BlockPos pos, BlockState state) {
        super(TYPE, pos, state);
    }

    public float currentOutput() {
        return this.currentOutput;
    }

    @Override
    protected AbstractCircuit getOwner() {
        return ESBlocks.delayCircuit;
    }

    @Override
    public void handleInputChange(TickPriority priority) {
        float[] inputs = this.getInputs(this.getOwner());
        float input = inputs[1];
        if (this.queuedOutputs.isEmpty() ? RedstoneUtil.didChange(input, this.currentOutput) : RedstoneUtil.didChange(input, ((Float)this.queuedOutputs.get(this.queuedOutputs.size() - 1).getLeft()).floatValue())) {
            int delay = 2 * this.settingDelay;
            this.queuedOutputs.add((Pair<Float, Long>)Pair.of((Object)Float.valueOf(input), (Object)((long)delay + this.ticksExisted - this.ticksExisted % 2L)));
            this.m_6596_();
        }
    }

    @Override
    public void tick() {
        ++this.ticksExisted;
        if (!this.f_58857_.f_46443_ && !this.queuedOutputs.isEmpty()) {
            long removeTime;
            boolean didChange = false;
            do {
                Pair<Float, Long> nextInQueue;
                if ((removeTime = ((Long)(nextInQueue = this.queuedOutputs.get(0)).getRight()).longValue()) > this.ticksExisted) continue;
                this.queuedOutputs.remove(0);
                this.currentOutput = ((Float)nextInQueue.getLeft()).floatValue();
                didChange = true;
            } while (removeTime <= this.ticksExisted && !this.queuedOutputs.isEmpty());
            if (didChange) {
                this.recalculateOutput();
                this.m_6596_();
            }
        }
    }

    @Override
    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128405_("setting_d", this.settingDelay);
        nbt.m_128359_("setting_s_d", this.settingStrDelay);
        nbt.m_128356_("existed", this.ticksExisted);
        nbt.m_128350_("curr_output", this.currentOutput);
        for (int i = 0; i < this.queuedOutputs.size(); ++i) {
            Pair<Float, Long> outputPair = this.queuedOutputs.get(i);
            nbt.m_128350_(i + "_queue_out", ((Float)outputPair.getLeft()).floatValue());
            nbt.m_128356_(i + "_queue_time", ((Long)outputPair.getRight()).longValue());
        }
    }

    @Override
    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.settingDelay = nbt.m_128451_("setting_d");
        this.settingStrDelay = nbt.m_128461_("setting_s_d");
        this.ticksExisted = nbt.m_128454_("existed");
        this.currentOutput = nbt.m_128457_("curr_output");
        int i = 0;
        this.queuedOutputs.clear();
        while (nbt.m_128441_(i + "_queue_out")) {
            this.queuedOutputs.add((Pair<Float, Long>)Pair.of((Object)Float.valueOf(nbt.m_128457_(i + "queue_out")), (Object)nbt.m_128454_(i + "queue_time")));
            ++i;
        }
    }

    public Component m_5446_() {
        return new TranslatableComponent("container.delay_circuit");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory playerInv, Player player) {
        return new DelayCircuitContainer(id, playerInv, CircuitContainer.encodeData(CircuitContainer.createEmptyBuf(), this.f_58858_, this.settingStrDelay));
    }

    @Override
    public void receiveNBT(CompoundTag nbt, @Nullable ServerPlayer sender) {
        this.settingDelay = Math.max(1, Math.round(nbt.m_128457_("value_0")));
        this.settingStrDelay = nbt.m_128461_("text_0");
        if (!this.queuedOutputs.isEmpty()) {
            this.currentOutput = ((Float)this.queuedOutputs.get(this.queuedOutputs.size() - 1).getLeft()).floatValue();
            this.queuedOutputs.clear();
        }
        this.m_6596_();
        this.recalculateOutput();
    }
}

